require 'page-object'

class Modal
  include PageObject

  div(:modalDialog, :css => '.ui-popup-container')
  div(:modalTitle, :css => '.ui-popup-container .ui-header')
  div(:content, :css => '.ui-popup-container div.ui-content')
  div(:loadingModal, :css => '.ui-loader')

  elements(:buttons, :button, :css=>'.popup-footer-buttons button')

  #VHA external site definitions
  #site-title
 h1(:vha_site_title, :id => 'site-title')

  div(:cancel_modal, :css => '#leave-confirmation-popup')
  button(:cancel_yes, :css => '#leave-confirmation-yes-btn')
  button(:cancel_no, :css => '#leave-confirmation-no-btn')
  button(:confirm_continue, :id => 'confirm-continue-btn')
  button(:confirm_return, :id => 'confirm-return-btn')
  button(:yes_cancel_request, :id => 'request-cancellation-continue-btn')
  button(:no_cancel_request, :id => 'request-cancellation-return-btn')

  #exit Modal
  div(:exit_modal, :css => '#leave-confirmation')

  #external link Confirmation Modal
  div(:leaveConfirm, :css=>'#external-nav')
  button(:continue, :css=>'#external-nav-continue-btn')
  button(:return, :css=>'#external-nav-return-btn')




  def isModalPopUpPresent()
    begin
      return modalDialog_element.exists?
    rescue Exception=>e
      return false
    end
  end
end